/* Copyright (C) 2015-2018 RealVNC Ltd.  All Rights Reserved.
 */

#include <vnccommon/Clock.h>

using namespace vnccommon;


Duration::Duration()
    :   mValueMs(0)
{
}

Duration::Duration(const vnc_int64_t valueMs)
    :   mValueMs(valueMs)
{
}

bool Duration::operator<(const Duration& o) const
{
    return mValueMs < o.mValueMs;
}

bool Duration::operator>(const Duration& o) const
{
    return mValueMs > o.mValueMs;
}

bool Duration::operator<=(const Duration& o) const
{
    return mValueMs <= o.mValueMs;
}

bool Duration::operator>=(const Duration& o) const
{
    return mValueMs >= o.mValueMs;
}

bool Duration::operator==(const Duration& o) const
{
    return mValueMs == o.mValueMs;
}

bool Duration::operator!=(const Duration& o) const
{
    return mValueMs != o.mValueMs;
}

Duration Duration::operator+(const Duration& o) const
{
    return Duration(mValueMs + o.mValueMs);
}

Duration Duration::operator-(const Duration& o) const
{
    return Duration(mValueMs - o.mValueMs);
}

vnc_int64_t Duration::getMs() const
{
    return mValueMs;
}

MonotonicTimestamp::Range::Range(
        const MonotonicTimestamp start,
        const MonotonicTimestamp end)

    :   mStart(start),
        mEnd(end)
{
}

bool MonotonicTimestamp::Range::contains(MonotonicTimestamp timestamp) const
{
    return timestamp >= mStart && timestamp < mEnd;
}

MonotonicTimestamp::MonotonicTimestamp()
    :   mValueMs(0)
{
}

MonotonicTimestamp::MonotonicTimestamp(const vnc_int64_t valueMs)
    :   mValueMs(valueMs)
{
}

vnc_int64_t MonotonicTimestamp::getMs() const
{
    return mValueMs;
}

MonotonicTimestamp MonotonicTimestamp::operator+(const Duration& o) const
{
    return MonotonicTimestamp(mValueMs + o.getMs());
}

MonotonicTimestamp MonotonicTimestamp::operator-(const Duration& o) const
{
    return MonotonicTimestamp(mValueMs - o.getMs());
}

Duration MonotonicTimestamp::operator-(const MonotonicTimestamp& o) const
{
    return Duration(mValueMs - o.mValueMs);
}

bool MonotonicTimestamp::operator<(const MonotonicTimestamp& o) const
{
    return mValueMs < o.mValueMs;
}

bool MonotonicTimestamp::operator>(const MonotonicTimestamp& o) const
{
    return mValueMs > o.mValueMs;
}

bool MonotonicTimestamp::operator<=(const MonotonicTimestamp& o) const
{
    return mValueMs <= o.mValueMs;
}

bool MonotonicTimestamp::operator>=(const MonotonicTimestamp& o) const
{
    return mValueMs >= o.mValueMs;
}

bool MonotonicTimestamp::operator==(const MonotonicTimestamp& o) const
{
    return mValueMs == o.mValueMs;
}

bool MonotonicTimestamp::operator!=(const MonotonicTimestamp& o) const
{
    return mValueMs != o.mValueMs;
}

